from typing import Optional

def get_clean_romaji(_s):
    return _s.strip(" \n\t\r").replace("・", ".").replace("  ", " ").replace("  ", " ").replace("  ", " ")

def japanese_to_romaji(text: str, capitalize: bool = False, 
                       passport: bool = False) -> str:
    try:
        import pykakasi
    except ImportError:
        raise ImportError(
            "pykakasi is required for Japanese to romaji conversion. "
            "Install it with: pip install pykakasi --break-system-packages"
        )

    kks = pykakasi.kakasi()

    result = kks.convert(text)

    romaji_parts = [item['hepburn'] if 'hepburn' in item else item.get('orig', '') 
                    for item in result]
    romaji_text = ''.join(romaji_parts)

    if passport:
        romaji_text = romaji_text.replace('ō', 'o').replace('ū', 'u')

    if capitalize:
        romaji_text = romaji_text.capitalize()
    
    return get_clean_romaji(romaji_text)

def japanese_to_romaji_spaced(text: str, capitalize_words: bool = False) -> str:
    try:
        import pykakasi
    except ImportError:
        raise ImportError(
            "pykakasi is required. Install with: pip install pykakasi --break-system-packages"
        )
    
    kks = pykakasi.kakasi()
    result = kks.convert(text)
    
    romaji_parts = []
    for item in result:
        romaji = item['hepburn'] if 'hepburn' in item else item.get('orig', '')
        if capitalize_words:
            romaji = romaji.capitalize()
        romaji_parts.append(get_clean_romaji(romaji))
    
    return (' '.join(romaji_parts))